library(tximport)
#biocLite("GenomicFeatures")
#Diretorio do output do salmon
dir <- "/work/tbLincRnas/pipeline/salmon/output"
list.files(dir)

#Criando os path para os arquivos quant.sf de cada sample
samples <- read.table(file.path(dir, "samples_iPSCs_TFB.txt"), header = TRUE)
head(samples)
files <- file.path(dir, samples$samples, "quant.sf")
files
#names(files) <- paste0("samples",1:18)
head(files)
all(file.exists(files))

#Criando tx2gene do .gtf de noncoding
library(readr)
csv = "/work/tbLincRnas/pipeline/gtf_to_fasta/lncRNA"
tx2gene <- read_tsv(file.path(csv, "tx2gene.noncoding.csv"))
head(tx2gene)

#Importando pelo tximport
library(rjson)
txi <- tximport(files, type = "salmon", tx2gene = tx2gene)
names(txi)
head(txi$counts)
head(txi$abundance)
save(txi$counts, file = "tximport_salmon.RData")
#write.csv(txi, file = "tximport_salmon.csv", row.names = TRUE)
# write.csv(txi$counts, file = "tximport_salmon_counts.csv")
#Tutorial do edgeR do tximport
library(edgeR)
cts <- txi$counts
normMat <- txi$length
normMat <- normMat/exp(rowMeans(log(normMat)))
txi$counts
o <- log(calcNormFactors(cts/normMat)) + log(cts/normMat)
y <- DGEList(cts)
y$samples
y$offset <- t(t(log(normMat)) +o)
